---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Basin of Attraction (diagnostic)

> Region in state-space from which trajectories converge to a Form under ⊚.

---

## Definition

- Convergence region
- Pull zone boundary
- Stability domain
- Return territory

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Pull zone | State region | `Monitor`, `Zone` |
| Return path | Flow track | `Check`, `Path` |
| Domain size | Space bound | `Test`, `Size` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Pull zone | Natural draw | "Pulls back" |
| Return path | Way home | "Finds center" |
| Domain size | Safe space | "Room to move" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| State region | Natural draw | How pull works |
| Flow track | Way home | How return flows |
| Space bound | Safe space | How room forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Force field | Energy well |
| Networks | State pull | Link draw |
| Cognition | Pattern draw | Mind pull |
| Systems | Flow pull | Natural draw |

---

## Scale Effects

How Basin of Attraction manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum well | Wave pull |
| λV | Gate draw | State zone |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase pull | Pattern draw |
| ∇S | Structure zone | Clear pull |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave zone | Light pull |
| λV | Field draw | Space well |

Note: At extreme scales, basins face fundamental limits (e.g., quantum wells at ε, causal zones at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: pull threshold
- c: zone capacity
- ψA: phase domain
- λV: gate region

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern well | Wave pull |
| Human | λV | Gate zone | Flow draw |
| Cosmic | ψA | Phase draw | Field well |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Small well | Pattern escape | No hold |
| Human | Weak pull | Path loss | Won't return |
| Cosmic | Zone break | Field escape | Lost draw |

---

## Diagnostic Checklist

Technical tests:
- [ ] Zone mapped
- [ ] Pull measured
- [ ] Size known
- [ ] Paths tracked

Humane tests:
- [ ] Draw felt
- [ ] Return clear
- [ ] Space enough
- [ ] Center holds

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical attraction nor experiential pull alone captures its full meaning.

---

## See Also

- [[Stability Margin (diagnostic)]]
- [[Hysteresis (diagnostic)]]
- [[Resilience (diagnostic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented